function test_suite = testCumsum %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
assertTrue(isempty(cumsum(x)))

function testDefault
x = polysym;
assertTrue(iszero(cumsum(x)))

function testRealScalar
x = polysym(pi);
assertEqual(cumsum(x),x);

function testCharScalar
x = polysym('x');
assertEqual(cumsum(x),x);

function testArrayOfOnes
x = polysym(ones(3,1));
assertEqual(cumsum(x),[x(1); x(1)+x(2); x(1)+x(2)+x(3)])

function testArrayOfZeros
x = polysym(zeros(3,1));
assertEqual(cumsum(x),x)

function testRealVectorWithZero
x = polysym(0:2);
assertEqual(cumsum(x),[x(1) x(2) x(2)+x(3)]);

function testCharColumnVector
x = polysym('x',[3 1]);
assertEqual(cumsum(x),[x(1); x(1)+x(2); x(1)+x(2)+x(3)]);

function testMatrix
x = polysym('x',2);
assertEqual(cumsum(x),[x(1,:); x(1,:)+x(2,:)]);

function testMatrixSecondDim
x = polysym('x',2);
assertEqual(cumsum(x,2),[x(:,1) x(:,1)+x(:,2)]);

function testDimTooLarge
polysyms('x')
f = @() x.cumsum(3);
assertExceptionThrown(f,'MATLAB:polysym:diff:notLess')

function testDimTooSmall
polysyms('x')
f = @() x.cumsum(0);
assertExceptionThrown(f,'MATLAB:polysym:diff:notGreater')
